clear all

* Set Folder to input one

cd ..\Inputs

* Import real potential GDP estimates from CBO (obtained from ALFRED)

import excel "Real Time Output Gap (Orphanides).xlsx", ///
sheet(FINAL DATA | FOMC frequency) cellrange(A2) firstrow clear

* Rename variables

rename GreenbookPublicationDate GBpublicationdate
rename Year year
rename Month month
rename Day day
rename Quarter quarter
rename tt ORPGtAt
rename tt1 ORPGtAtm1
rename tt3 ORPGtAtp3
rename Thenumberofdaysbetweenthed DaysSince66
rename Thenumberofdayspastafterpr DaysBetMeet
rename K GREGtAt
rename L GREGtAtm1
rename M GREGtAtp3
rename N FINGtAt
rename O FINGtAtm1
rename P FINGtAtp3

* Label variables

label var ORPGtAt   "Orphanides, Output gap at time t as available at time t"
label var ORPGtAtm1 "Orphanides, Output gap at time t-1 as available at time t"
label var ORPGtAtp3 "Orphanides, Output gap at time t+3 as available at time t"
label var GREGtAt   "Greenbook, Output gap at time t as available at time t"
label var GREGtAtm1 "Greenbook, Output gap at time t-1 as available at time t"
label var GREGtAtp3 "Greenbook, Output gap at time t+3 as available at time t"
label var FINGtAt   "Final, Output gap at time t as available at time t"
label var FINGtAtm1 "Final, Output gap at time t-1 as available at time t"
label var FINGtAtp3 "Final, Output gap at time t+3 as available at time t"

* Merge Orphanides GAP with RGDP data

merge 1:1 year quarter month day using Greenbook_gRGDP
drop _merge
drop if GBdate=="19791012"
drop DaysSince66 DaysBetMeet
order DATE GBdate GBpublicationdate year quarter month day

* Merge with Greenbook GAP data

merge 1:1 year quarter month day using Greenbook_GAP
drop FOMCmeetingdate Yearquarter t wk meeting _merge
replace FINGtAt  =gapf0 if FINGtAt==.
replace FINGtAtm1=gapm1 if FINGtAtm1==.
replace FINGtAtp3=gapf3 if FINGtAtp3==.

* Turn growth rates, which are Q/Q but annualized into simple Q/Q growth rates

foreach v of varlist gRGDP* {
	gen Q`v' = ((1+`v'/100)^(1/4)-1)*100
}

* Generate growth between t and t+3

gen QGR3P = ((QgRGDPF1/100+1)*(QgRGDPF2/100+1)*(QgRGDPF3/100+1)-1)*100

* Generate growth rates for potential output based on the gap estimates and the
* growth estimates for real gdp: three quarters out 

gen gRpot=(((FINGtAt/100+1)/(FINGtAtp3/100+1)*(QGR3P/100+1))-1)*100
gen gRpot3=gRpot*(4/3) /*annualized */

* Generate growth rates for potential output based on the gap estimates and the
* growth estimates for real gdp: one quarter back

gen gRpot0=(((FINGtAtm1/100+1)/(FINGtAt/100+1)*(QgRGDPF1/100+1))-1)*400

* Drop observartions with no information on gRpot

drop if gRpot0==.
egen count3=count(gRpot3), by(year quarter)
drop if gRpot3==. & count3!=0

* Keep only first meetings in the quarter (within the ones that had gRpot data)

gen GBdateN=mdy(month,day,year)
format GBdateN %td
egen mindate=min(GBdateN), by(year quarter)
keep if mindate==GBdateN
sort year quarter
egen tt=group(year quarter)

* Set time series to be able to use lag and difference operators

tsset tt

* Generate revisions

gen revRpot=D.gRpot3
keep year quarter gRpot0 gRpot3 revRpot

* Rename variables

ds year quarter, not
foreach var of varlist `r(varlist)' {
	rename `var' ORP`var'
}

* Change to output folder and save

cd ..\Outputs
save Data_ORP, replace
